Max_iter=10000; % max iterations
toll=0.01;   % tolerance parameter
alpha=0.001; % step size

nx=100;
Deltax=1/nx;
x=linspace(0,1,nx+1); % space discretization

U1 = cell(1,4);
U2 = cell(1,4);
psi = cell(1,4);
torsmooth = cell(1,4);


% input
nu=[0.5 , 1 , 10 , 100]; %stiffness ratios%
phip=-pi/4;
U2tar=4+5*sin(2*pi*x)';

% operators
D1=(1/Deltax)*(1/2)*(-diag([1 ,zeros(1,( nx +1)-3)],2) + diag([4 ,ones(1,(nx+1)-2)],1) + diag([-3 ,zeros(1,(nx+1)-2),3],0) -diag([ones(1,(nx+1)-2),4],-1) + diag([zeros(1,(nx+1)-3) , 1],-2) );
Ix1=Deltax*0.5*(triu(ones(nx+1)) + triu(ones(nx+1),1) - [zeros(nx+1,nx) , ones(nx+1,1)]);
I0x=Deltax*0.5*(tril(ones(nx+1)) + tril(ones(nx+1),-1) - [ones(nx+1,1) , zeros(nx+1,nx)]);

% initial data
U1IN = 0*x';
U2IN = U2tar;

U12 = [ U1IN , U2IN ];

% gradient
grad = @(nu,U1,U2) [    U1          + nu*cos(phip)*Ix1*(cos(phip)*I0x*U1 + sin(phip)*I0x*U2)  ...
                   , U2 - U2tar  + nu*sin(phip)*Ix1*(cos(phip)*I0x*U1 + sin(phip)*I0x*U2)  ];

% tolerance function

%  funtoll = @(x) 0.5*Deltas*(sum(x(:,1).*x(:,1)) + sum(x(:,2).*x(:,2)));
   funtoll = @(x) max( [  max(abs(x(:,1))) ,  max(abs(x(:,2)))  ] );

for k=1:4

 
 iter=1;
while iter < Max_iter && funtoll(grad(nu(k),U12(:,1),U12(:,2)))>toll
  
 iter = iter + 1;  
 
 U12 = U12 - alpha*grad(nu(k),U12(:,1),U12(:,2));
 
end    

U1{1,k}=U12(:,1);
U2{1,k}=U12(:,2);

psi{1,k}=atan2(U12(:,2),U12(:,1));
tor=D1*psi{1,k};

smoothpar=0.9999;
torsmoothpp=csaps(x,tor,smoothpar);
torsmooth{1,k}= fnval(x,torsmoothpp);
end


for k=1:4

figure

l=max(max(abs(U1{1,k})),max(abs(U2{1,k}))) + 1 ;

subplot(1,3,[1,2]);
plot(U1{1,k},U2{1,k},...
    0*x,-l + x*2*l,'--',...
    -sin(phip)*(-l + x*2*l),cos(phip)*(-l + x*2*l),'--',...
    U1{1,k}(1),U2{1,k}(1),'o')
axis equal
grid on
ylabel('U_2 / L^{-1}')
xlabel('U_1 / L^{-1}')

title(['\nu =' , num2str(nu(k))])

legend('U(s)','U_{1} = 0',' line generated by e_{p}^{\perp}','U(0)','Location','southwest')


subplot(1,3,3);
plot(x,torsmooth{1,k}) 
ylabel('\tau / L^{-1}')
xlabel('s / L')

end

